@extends('layouts.app')

@section('content')
    <!-- Page Header -->
    <div class="py-8 sm:py-12 md:py-16 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center">
                <p class="text-2xl sm:text-3xl md:text-4xl text-gray-600">{{ $company->name }}</p>
                <div class="mt-4 flex justify-center flex-wrap gap-x-6 gap-y-2 text-sm text-gray-500">
                    <!-- Email -->
                    <span class="inline-flex items-center gap-2">
                        <svg class="w-4 h-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                            aria-hidden="true">
                            <rect x="3" y="5" width="18" height="14" rx="2"></rect>
                            <path d="M3 7l9 6 9-6"></path>
                        </svg>
                        {{ $company->email }}
                    </span>

                    <!-- Phone -->
                    <span class="inline-flex items-center gap-2">
                        <svg class="w-4 h-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                            aria-hidden="true">
                            <path stroke-linecap="round" stroke-linejoin="round"
                                d="M22 16.92v3a2 2 0 0 1-2.18 2 19.8 19.8 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6A19.8 19.8 0 0 1 2 4.18 2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72c.12.81.32 1.6.59 2.36a2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.72-1.11a2 2 0 0 1 2.11-.45c.76.27 1.55.47 2.36.59A2 2 0 0 1 22 16.92z" />
                        </svg>
                        {{ $company->phone }}
                    </span>

                    <!-- Company Code / Office -->
                    <span class="inline-flex items-center gap-2">
                        <svg class="w-4 h-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                            aria-hidden="true">
                            <rect x="6" y="3" width="12" height="18" rx="2"></rect>
                            <path d="M3 21h18"></path>
                            <path d="M9 7h2v2H9zM13 7h2v2h-2zM9 11h2v2H9zM13 11h2v2h-2z"></path>
                            <path d="M11 21v-4h2v4"></path>
                        </svg>
                        {{ $company->company_code }}
                    </span>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="py-8 sm:py-12 md:py-16 bg-white">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Statistik -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                <!-- Total Karyawan -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-none">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#192D50] rounded-full flex items-center justify-center">
                                    <svg class="w-4 h-4 text-white" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                        stroke-width="2" aria-hidden="true">
                                        <circle cx="12" cy="8" r="3"></circle>
                                        <path stroke-linecap="round" stroke-linejoin="round"
                                            d="M6 20c0-3.314 2.686-6 6-6s6 2.686 6 6"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Total Karyawan</p>
                                <p class="text-2xl font-semibold text-gray-900">{{ $employees->count() }}</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Hasil MCU Selesai -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-none">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#192D50] rounded-full flex items-center justify-center">
                                    <svg class="w-4 h-4 text-white" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                        stroke-width="2" aria-hidden="true">
                                        <circle cx="12" cy="12" r="9"></circle>
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M8.5 12.5l2.5 2.5 4.5-5">
                                        </path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Hasil MCU Selesai</p>
                                <p class="text-2xl font-semibold text-gray-900">
                                    {{ $allResults->where('status', 'completed')->count() }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Menunggu Hasil -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-none">
                    <div class="p-6">
                        <div class="flex items-center">
                            <div class="flex-shrink-0">
                                <div class="w-8 h-8 bg-[#192D50] rounded-full flex items-center justify-center">
                                    <svg class="w-4 h-4 text-white" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                        stroke-width="2" aria-hidden="true">
                                        <circle cx="12" cy="12" r="9"></circle>
                                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 7v5l3 2"></path>
                                    </svg>
                                </div>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Menunggu Hasil</p>
                                <p class="text-2xl font-semibold text-gray-900">
                                    {{ $allResults->where('status', 'pending')->count() }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Informasi Perusahaan -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-none mb-8">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Informasi Perusahaan</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <h4 class="font-medium text-gray-900 mb-2">Data Perusahaan</h4>
                            <div class="space-y-2 text-sm">
                                <p><span class="font-medium">Nama:</span> {{ $company->name }}</p>
                                <p><span class="font-medium">Email:</span> {{ $company->email }}</p>
                                <p><span class="font-medium">Telepon:</span> {{ $company->phone }}</p>
                                <p><span class="font-medium">Kode Perusahaan:</span> <span
                                        class="font-mono bg-gray-100 px-2 py-1 rounded">{{ $company->company_code }}</span>
                                </p>
                            </div>
                        </div>
                        <div>
                            <h4 class="font-medium text-gray-900 mb-2">Kontak Perusahaan</h4>
                            <div class="space-y-2 text-sm">
                                <p><span class="font-medium">Kontak:</span> {{ $company->contact_person }}</p>
                                <p><span class="font-medium">Email Kontak:</span> {{ $company->contact_email }}</p>
                                <p><span class="font-medium">Telepon Kontak:</span> {{ $company->contact_phone }}</p>
                                <p><span class="font-medium">Alamat:</span> {{ $company->address }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Daftar Karyawan -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-none">
                <div class="p-6">
                    <h3 class="text-lg font-medium text-gray-900 mb-4">Daftar Karyawan</h3>

                    @if ($employees && $employees->count() > 0)
                        <div class="overflow-x-auto">
                            <table class="min-w-full divide-y divide-gray-200">
                                <thead class="bg-gray-50">
                                    <tr>
                                        <th
                                            class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Nama</th>
                                        <th
                                            class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            No. Karyawan</th>
                                        <th
                                            class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Posisi</th>
                                        <th
                                            class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Departemen</th>
                                        <th
                                            class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Status MCU</th>
                                        <th
                                            class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                            Aksi</th>
                                    </tr>
                                </thead>
                                <tbody class="bg-white divide-y divide-gray-200">
                                    @foreach ($employees as $employee)
                                        @php
                                            // Cari hasil MCU dari kedua sistem
                                            $employeeResult = $allResults->where('employee_id', $employee->id)->first();
                                        @endphp
                                        <tr>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                <div class="text-sm font-medium text-gray-900">{{ $employee->name }}</div>
                                                <div class="text-sm text-gray-500">{{ $employee->email }}</div>
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                                {{ $employee->employee_number }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                                {{ $employee->position }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                                {{ $employee->department }}</td>
                                            <td class="px-6 py-4 whitespace-nowrap">
                                                @if ($employeeResult)
                                                    <span
                                                        class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                                        @if ($employeeResult->status == 'completed') bg-green-100 text-green-800
                                                        @elseif($employeeResult->status == 'pending') bg-yellow-100 text-yellow-800
                                                        @else bg-red-100 text-red-800 @endif">
                                                        {{ ucfirst($employeeResult->status) }}
                                                    </span>
                                                @else
                                                    <span
                                                        class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                                        Belum Ada
                                                    </span>
                                                @endif
                                            </td>
                                            <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                                @if ($employeeResult && $employeeResult->result_file_path)
                                                    <div class="flex items-center space-x-2">
                                                        <a href="{{ route('mcu.file.view', ['resultId' => $employeeResult->id, 'type' => isset($employeeResult->is_direct) ? 'exam' : 'employee']) }}"
                                                            target="_blank"
                                                            class="inline-flex items-center px-3 py-1 border border-transparent text-xs font-medium rounded text-[#CBB4B0] bg-white hover:bg-[#192D50] hover:text-white transition duration-150">
                                                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                                            </svg>
                                                            Preview
                                                        </a>
                                                        <a href="{{ route('mcu.file.download', ['resultId' => $employeeResult->id, 'type' => isset($employeeResult->is_direct) ? 'exam' : 'employee']) }}"
                                                            class="inline-flex items-center px-3 py-1 border border-transparent text-xs font-medium rounded text-white bg-[#192D50] hover:bg-[#8B8B8B] transition duration-150">
                                                            <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                                            </svg>
                                                            Download
                                                        </a>
                                                    </div>
                                                @else
                                                    <span class="text-gray-400">-</span>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-8">
                            <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-gray-100">
                                <svg class="h-6 w-6 text-gray-400" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z">
                                    </path>
                                </svg>
                            </div>
                            <h3 class="mt-4 text-lg font-medium text-gray-900">Belum Ada Karyawan</h3>
                            <p class="mt-2 text-sm text-gray-600">
                                Belum ada data karyawan yang terdaftar.
                                Silakan hubungi administrator untuk menambahkan data karyawan.
                            </p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
